﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MultipleMonitorInfo
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < Screen.AllScreens.Length; i++)
            {
                int screenNumber = i + 1;
                screenList.Items.Add("Screen " + screenNumber);
            }
        }

        private void screenList_Click(object sender, EventArgs e)
        {
            if (this.screenProperties.Items.Count > 0)
            {
                screenProperties.Items.Clear();
            }

            List<ListViewItem> items = GetScreenPropertiesList(screenList.SelectedIndex);
            SetScreenPropertiesListView(items);
        }

        private void btnClear_Click(object sender, EventArgs e)
        {
            ClearPropertiesList();
        }

        private void btnGetPrimaryInfo_Click(object sender, EventArgs e)
        {
            List<ListViewItem> items = GetScreenPropertiesList(GetPrimaryScreenID());
            SetScreenPropertiesListView(items);
        }

        private void btnGetCurrentScreenInfo_Click(object sender, EventArgs e)
        {
            List<ListViewItem> items = GetScreenPropertiesListFromControl(this);
            SetScreenPropertiesListView(items);
        }

        private void SetScreenPropertiesListView(List<ListViewItem> items)
        {
            ClearPropertiesList();

            foreach (ListViewItem item in items)
            {
                screenProperties.Items.Add(item);
            }
        }

        private void ClearPropertiesList()
        {
            if (this.screenProperties.Items.Count > 0)
            {
                screenProperties.Items.Clear();
            }
        }

        private int GetPrimaryScreenID()
        {
            for (int i = 0; i < Screen.AllScreens.Length; i++)
            {
                if (Screen.AllScreens[i].Primary)
                {
                    return i;
                }
            }

            return 0; // default screen
        }

        private List<ListViewItem> GetScreenPropertiesList(int screenNumber)
        {
            List<ListViewItem> items = new List<ListViewItem>();

            Screen screen = Screen.AllScreens[screenNumber];

            items.Add(CreateListViewItem("Width", screen.Bounds.Size.Width.ToString()));
            items.Add(CreateListViewItem("Height", screen.Bounds.Size.Height.ToString()));
            items.Add(CreateListViewItem("BitsPerPixel", screen.BitsPerPixel.ToString()));
            items.Add(CreateListViewItem("Primary", screen.Primary.ToString()));
            items.Add(CreateListViewItem("DeviceName", screen.DeviceName.ToString()));
            items.Add(CreateListViewItem("Bounds.X", screen.Bounds.X.ToString()));
            items.Add(CreateListViewItem("Bounds.Y", screen.Bounds.Y.ToString()));

            return items;
        }

        private List<ListViewItem> GetScreenPropertiesListFromControl(Control control)
        {
            List<ListViewItem> items = new List<ListViewItem>();

            Screen screen = Screen.FromControl(control);

            items.Add(CreateListViewItem("Width", screen.Bounds.Size.Width.ToString()));
            items.Add(CreateListViewItem("Height", screen.Bounds.Size.Height.ToString()));
            items.Add(CreateListViewItem("BitsPerPixel", screen.BitsPerPixel.ToString()));
            items.Add(CreateListViewItem("Primary", screen.Primary.ToString()));
            items.Add(CreateListViewItem("DeviceName", screen.DeviceName.ToString()));
            items.Add(CreateListViewItem("Bounds.X", screen.Bounds.X.ToString()));
            items.Add(CreateListViewItem("Bounds.Y", screen.Bounds.Y.ToString()));

            return items;
        }

        private static ListViewItem CreateListViewItem(string property, string value)
        {
            return new ListViewItem(new string[] { property, value });
        }
    }
}
